/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.transmission.sequencer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.compat.computercraft.ComputerScreen;
import com.simibubi.create.content.kinetics.transmission.sequencer.ConfigureSequencedGearshiftPacket;
import com.simibubi.create.content.kinetics.transmission.sequencer.Instruction;
import com.simibubi.create.content.kinetics.transmission.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Vector;
import me.pepperbell.simplenetworking.C2SPacket;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class SequencedGearshiftScreen
extends AbstractSimiScreen {
    private final class_1799 renderedItem = AllBlocks.SEQUENCED_GEARSHIFT.asStack();
    private final AllGuiTextures background = AllGuiTextures.SEQUENCER;
    private IconButton confirmButton;
    private SequencedGearshiftBlockEntity be;
    private class_2499 compareTag;
    private Vector<Instruction> instructions;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedGearshiftScreen(SequencedGearshiftBlockEntity be) {
        super((class_2561)CreateLang.translateDirect("gui.sequenced_gearshift.title", new Object[0]));
        this.instructions = be.instructions;
        this.be = be;
        this.compareTag = Instruction.serializeAll(this.instructions);
    }

    protected void method_25426() {
        int row;
        if (this.be.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, this::renderAdditional, (class_437)this, this.be.computerBehaviour::hasAttachedComputer));
        }
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-20, 0);
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inputs = new Vector(5);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row, x, y);
        }
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.method_25419());
        this.method_37063((class_364)this.confirmButton);
    }

    public void initInputsOfRow(int row, int backgroundX, int backgroundY) {
        int x = backgroundX + 30;
        int y = backgroundY + 20;
        int rowHeight = 22;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        this.removeWidgets(rowInputs);
        rowInputs.clear();
        int index = row;
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 18).forOptions(SequencerInstructions.getOptions()).calling(state -> this.instructionUpdated(index, (int)state)).setState(instruction.instruction.ordinal()).titled(CreateLang.translateDirect("gui.sequenced_gearshift.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 58, y + rowHeight * row, 28, 18).calling(state -> {
            instruction.value = state;
        });
        ScrollInput direction = new SelectionScrollInput(x + 88, y + rowHeight * row, 28, 18).forOptions(InstructionSpeedModifiers.getOptions()).calling(state -> {
            instruction.speedModifier = InstructionSpeedModifiers.values()[state];
        }).titled(CreateLang.translateDirect("gui.sequenced_gearshift.speed", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(direction);
        this.addRenderableWidgets(rowInputs);
        this.updateParamsOfRow(row);
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        SequencerInstructions def = instruction.instruction;
        boolean hasValue = def.hasValueParameter;
        boolean hasModifier = def.hasSpeedParameter;
        ScrollInput value = rowInputs.get(1);
        value.field_22763 = value.field_22764 = hasValue;
        if (hasValue) {
            value.withRange(1, def.maxValue + 1).titled(CreateLang.translateDirect(def.parameterKey, new Object[0])).withShiftStep(def.shiftStep).setState(instruction.value).onChanged();
        }
        if (def == SequencerInstructions.DELAY) {
            value.withStepFunction(context -> {
                int v = context.currentValue;
                if (!context.forward) {
                    --v;
                }
                if (v < 20) {
                    return context.shift ? 20 : 1;
                }
                return context.shift ? 100 : 20;
            });
        } else {
            value.withStepFunction(value.standardStep());
        }
        ScrollInput modifier = rowInputs.get(2);
        modifier.field_22763 = modifier.field_22764 = hasModifier;
        if (hasModifier) {
            modifier.setState(instruction.speedModifier.ordinal());
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.be.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, this::renderAdditional, (class_437)this, this.be.computerBehaviour::hasAttachedComputer));
        }
    }

    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int yOffset;
        AllGuiTextures toDraw;
        int row;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        for (row = 0; row < this.instructions.capacity(); ++row) {
            toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.getHeight() * row;
            toDraw.render(graphics, x, y + 16 + yOffset);
        }
        for (row = 0; row < this.instructions.capacity(); ++row) {
            toDraw = AllGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.getHeight() * row;
            if (row >= this.instructions.size()) {
                toDraw.render(graphics, x, y + 16 + yOffset);
                continue;
            }
            Instruction instruction = this.instructions.get(row);
            SequencerInstructions def = instruction.instruction;
            def.background.render(graphics, x, y + 16 + yOffset);
            this.label(graphics, 36, yOffset - 1, (class_2561)CreateLang.translateDirect(def.translationKey, new Object[0]));
            if (def.hasValueParameter) {
                String text = def.formatValue(instruction.value);
                int stringWidth = this.field_22793.method_1727(text);
                this.label(graphics, 90 + (12 - stringWidth / 2), yOffset - 1, (class_2561)class_2561.method_43470((String)text));
            }
            if (!def.hasSpeedParameter) continue;
            this.label(graphics, 127, yOffset - 1, instruction.speedModifier.label);
        }
        graphics.method_51439(this.field_22793, this.field_22785, x + (this.background.getWidth() - 8) / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, y + 4, 5841956, false);
        this.renderAdditional(graphics, mouseX, mouseY, partialTicks, x, y, this.background);
    }

    private void renderAdditional(class_332 graphics, int mouseX, int mouseY, float partialTicks, int guiLeft, int guiTop, AllGuiTextures background) {
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((class_1799)this.renderedItem).at((float)(guiLeft + background.getWidth() + 6), (float)(guiTop + background.getHeight() - 56), 100.0f)).scale(5.0).render(graphics);
    }

    private void label(class_332 graphics, int x, int y, class_2561 text) {
        graphics.method_27535(this.field_22793, text, this.guiLeft + x, this.guiTop + 26 + y, 0xFFFFEE);
    }

    public void sendPacket() {
        class_2499 serialized = Instruction.serializeAll(this.instructions);
        if (serialized.equals((Object)this.compareTag)) {
            return;
        }
        AllPackets.getChannel().sendToServer((C2SPacket)new ConfigureSequencedGearshiftPacket(this.be.method_11016(), serialized));
    }

    public void method_25432() {
        this.sendPacket();
    }

    private void instructionUpdated(int index, int state) {
        SequencerInstructions newValue;
        this.instructions.get((int)index).instruction = newValue = SequencerInstructions.values()[state];
        this.instructions.get((int)index).value = newValue.defaultValue;
        this.updateParamsOfRow(index);
        if (newValue == SequencerInstructions.END) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                this.removeWidgets(rowInputs);
                rowInputs.clear();
            }
        } else if (index + 1 < this.instructions.capacity() && index + 1 == this.instructions.size()) {
            this.instructions.add(new Instruction(SequencerInstructions.END));
            this.initInputsOfRow(index + 1, this.guiLeft, this.guiTop);
        }
    }
}

